#ifndef	CAR_SCROLL_H
#define CAR_SCROLL_H
//
#define VER_HIGH	12
#define VER_LOW		98				// firmware version. As of 8.20 it resides in carscroll.h it was defined in main.c before that.
/*
  Firmware versions 8.70 onwards radically different in the manner of bootservice- a much more streamlined interface henceforth.
  Firmware versions 9.62 and below used Flash Memory erroneously in MyWriteProgMemUpTo32 when writing more than 64 bytes at a time!
  Firmware version 10.95 and above implement auto sizing from the map table
  Firmware version 12.12 and above implement delta and integral values (averaged or not) and proper beep and invert calculations for multiple values
								   you can also apply delta and integral to either value index (VALUE or DUTY).
								   previous values are also stored! You can now also display accumulator values for each variable (and the 
								   accumulator can come from any of the valueindexes!!)
*/
// System Constants
#define INTERRUPT_ENABLE				1
#define	TESTING							0
#define USBPRIORITY						0
#define USE_CLIPPING					0
#define DEFAULT_SYSTEMDECP				1		// 1 decimal point accuracy default
#define MINSYSTEMDECP					0
#define MAXSYSTEMDECP					3
#define DISPLAY_COLUMNS 				15		// total number of columns of LED display (must be at least 15!)
#define DISPLAY_COLUMNS_AND_1			(DISPLAY_COLUMNS+1)
// some imodes other than zero
#define LOGGING_MODE					1
#define FLASHWRITE_MODE					2
//
#define CCPFALL							0x04
#define CCPRISE							0x05
#define CCPOFF							0x00
// Usb detect polarity
#define USBSENSEPOLARITY				1   // original hardware used a transistor where 0 was on, but as of version 11.13 this changed, polarity is reversed.
#define SCREENREFRESHPRIORITY			0
// Font Constants
#define CHAR_BLANKING					0x80
#define BIG_FONT_MIN					0x20
#define BIG_FONT_MAX					0x7A
#define SMALL_FONT_MIN					0x2D
#define SMALL_FONT_MAX					0x3A
// Constants for scrolling speed
#define DEFAULT_SCROLL_SPEED			10		// in ms, delay for scrolling
#define MINSCROLL_SPEED					5
#define MAXSCROLL_SPEED					40
#define DEFAULT_CHECK_PERIOD			8
#define DEFAULT_BEEP_PERIOD				0
#define DEFAULTBATTSLEEPMODE            16      // enabled (some seconds delay to off, with update freq about 1.6Hz this is approx 10 seconds delay to sleep)
#define OVERRIDE_LOWBATT_DELAYMS        500     // delay in ms to have button pressed to override the low battery protection circuit on reset
#define CALIBRATION_DELAY				1				// in ms
#define POWERON_DELAY					500				// in ms
//
#define NUM_DIGITS						8
#define TMRL_CCP_OFFSET					16.0	// empirical timer offset for frequency sampling - to take account of interrupt latency! (0-255) only 8 bit.
#define DUTY_CORRECTION_OFFSET			35.0	// for the asymmetrical duty calculation with the low pass filter on the CCP input
												// this is approximately equal to FOSC4_ON_8*(-RCln(1-vx/vo)) where vx is voltage threshold vx=2.6V vo=supply voltage = 5.0
												// R=3.9k C=8.2nF
#define TMRL_CCP_OFFSET_TIMES_2			(TMRL_CCP_OFFSET*2)
#define FOSC4							(12000000.0)	// the system clock frequency (48MHz/4, the 48MHz is derived from PLL stage from 20MHz crystal)
#define FOSC4TP                         ((NUM_UPDATE_VARS*128.0)/FOSC4)   // 256 from the tmr0HPeriod and 2.0 for the trapezoidal integral calculations!
#define FOSC4_ON_8						(FOSC4/8.0)		// the system clock frequency divided by 8
#define FOSC4_ON_16						(FOSC4/16.0)
#define DEFAULT_DIVIDER_UPPER			56000.0			// in Ohms (this is for the battery (analog) channel only!
#define DEFAULT_DIVIDER_LOWER			10000.0			// in Ohms
#define ADC_DELAY						20	    	    // ignored.
//
#define ADC_CURRENT						(0.0000003)		// 300nA
#define VOLTAGE_CORRECTION_22			(ADC_CURRENT*DEFAULT_DIV_U*1023.0/VOLTAGEREF)	// 2uA is ADC current draw and 22k resistor
#define VOLTAGE_CORRECTION_56			(ADC_CURRENT*DEFAULT_DIVIDER_UPPER*1023.0/VOLTAGEREF)
// These control the rounding mode for displaying!
#define DEFAULT_ROUNDINGMODE			0				// 0=rounding disabled 1=rounding enabled (this is the default value)
#define MINROUNDINGMODE					0
#define MAXROUNDINGMODE					1
#define DEFAULT_LIMIT_PERIOD            5
//
#define VOLTAGEREF						5.0
#define VOLTAGE_RANGE					VOLTAGEREF*(1.0+(DEFAULT_DIVIDER_UPPER/DEFAULT_DIVIDER_LOWER))	// this is the maximum voltage range for battery sense, approx 33V
#define FIXED_POINT_SCALE				255.0
#define DEFAULT_BATTSCALING				(FIXED_POINT_SCALE-SCALE_OFFSET)
#define SCALE_OFFSET					128.0
#define BATTSCALE						(VOLTAGE_RANGE/FIXED_POINT_SCALE)
#define DEFAULT_BATTMIN					(11.1/BATTSCALE)
#define DEFAULT_BATTMAX					(13.9/BATTSCALE)
#define VOLTAGE_RANGE_SCALE			    (VOLTAGE_RANGE/1023.0)
//
#define DEFAULT_DIV_U			        22000.0			    // in Ohms (this is for the analog channels excluding the battery)
#define DEFAULT_DIV_L			        10000.0			    // in Ohms
#define DEFAULT_ANALOG_SCALE            ((1.0+(DEFAULT_DIV_U/DEFAULT_DIV_L))*VOLTAGEREF)      // this is the default for polynomial (deg 0) for analog vars (Note: 3.2=22k and 10k divider)
#define DEFAULT_FREQUENCY_SCALE         (FREQ_MAX)          // this is the default for polynomial (deg 0) for frequency vars
#define DEFAULT_DUTY_SCALE				100.0
//
#define HYST_SCALE						250.0						// number of steps in the hysteresis
#define HYST_FULLSCALE					0.25  		    			// the maximum hyseteresis as a fraction... or 25%
#define DEFAULT_HYSTERESIS				((0.1/HYST_FULLSCALE)*HYST_SCALE)    // the default is 10%
#define DEFAULT_BATT_VOLTAGE_HYSTERESIS ((0.05/HYST_FULLSCALE)*HYST_SCALE)   // 5% hysteresis for battery voltage
#define CRITICAL_BEEP					8							// this must be higher than or equal to 4 (adds to beepPeriod)
//
#define OS_MAX							5
#define OS_MIDMAX						4
#define OS_MID							3						
#define OS_MIDMIN						2
#define OS_MIN							1
#define OS_DEFAULT						(OS_MID)
//
#define NAME_INDEX  					0
#define UNIT_INDEX 		 				1
#define STRING_DELIMITER				':'
//
#define READ_DIR						0
#define WRITE_DIR						1
//
//#define VARIABLE_MODE					0
//#define SYSTEM_MODE					1
//
#define FCHANNELS						2				// number of frequency channels
//
#define ABSMIN_BRIGHTNESS				5
#define ABSMAX_BRIGHTNESS				250
#define DELTA_BRIGHTNESS				(ABSMAX_BRIGHTNESS-ABSMIN_BRIGHTNESS)
#define DEFAULT_MINBRIGHTNESS			(100)
#define DEFAULT_MAXBRIGHTNESS			(ABSMAX_BRIGHTNESS)
#define LDR_MIN_RESISTANCE				20.0		// in kOhms, this is the lowest resistance of the LDR on the display board (with light)
#define LDR_MAX_RESISTANCE				18000.0		// in kOhms, this is the highest resistance of the LDR on the display board (with light)
#define LDR_DIVIDER_RESISTANCE			82.0		// in kOhms, the value of the resistor used in the LDR voltage divider
#define LDRMIN						    (1023.0*(LDR_DIVIDER_RESISTANCE)/(LDR_DIVIDER_RESISTANCE+LDR_MAX_RESISTANCE))			// the lowest value
#define LDRMAX							(1023.0*(LDR_DIVIDER_RESISTANCE)/(LDR_DIVIDER_RESISTANCE+LDR_MIN_RESISTANCE))			// the highest value
#define LDROFFSET						((LDRMAX-LDRMIN)/1000.0)
//
#define AVG_STRING_SIZE					32
#define NUM_STRINGS_PER_VAR				4
#define DEFAULT_DISPLAY_OBJECT			0
#define VALUE_INDEX						0
#define DUTY_INDEX						1
#define DELTA_INDEX						2
#define DELTA_DT_INDEX					3
//
#define NUMSUBINDEX         			2   		// value and unit so far...
#define ENDINDEX            			(NUM_STRINGS_PER_VAR*NUM_VARS*NUMSUBINDEX)    
//
#define LOT0CON							0x0080
#define HIT0CON							0x0088
#define DEFAULT_TMR0HPERIOD				0x48
#define MINTMR0HPERIOD					0x00
#define MAXTMR0HPERIOD					0xFF
#define MAX_POLY_INDEXES				(NUM_VARS*NUM_RAW)+1
#define MAX_POLY						51				// a 50 point polynomial coefficient memory (doubles) (the extra one is for the tail)
#define NUM_VALUES						4				// the total number- must be a power of 2.
#define NUM_VALUES_TIMES_2				(NUM_VALUES*2)
#define NUM_RAW							2
#define NUM_SCALING						2
#define NUM_DISPLAY_OBJECTS				11				// number of display objects (one is used for blanking only)
//
#define NUM_VARS						6
#define NUM_UPDATE_VARS					8				// the 6 variables + battery voltage and LDR
#define VAR_BATT						6
#define VAR_LDR							7
//
#define NUM_OUTPUTS						2
#define FREQ_MAX						10000.0			// this is the maximum measurable frequency on the frequency/duty cycle inputs
#define DECIMAL_POINT_SCALE				1000.0
#define PERCENT_SCALE					100.0
#define TEMPBUFF_SIZE					64
#define MINOR_DELAY_MS					16
#define MAJOR_DELAY_MS					24
//
#define SUPPLY_VOLTAGE					5.0
//
#define ANALOG_VAR						0				// variable type is analog
#define FREQUENCY_VAR 					1				// variable type is frequency/duty cycle
#define DEPENDENT_VAR                   2
#define SILENT_VAR                      3
//
//#define DEFAULT_VARTYPE					(ANALOG_VAR)
//
#define MINDISPLAY_MODE					0
#define MAXDISPLAY_MODE					2
//
#define MODE_NORMAL						0
#define MODE_AVG						1				// averaging for variables
#define DEFAULT_MODE					(MODE_AVG)
//
#define SHORT_BUTTON_PRESS_THRESHOLD	20				// in units of about 28ms
#define BUTTON_CHECK_DIVISOR			0xFF			// must be a number of the form 2^N-1
//
#define NO_PRESS						0
#define SHORT_PRESS						1
#define LONG_PRESS						2
//
#define	SERBIT							PORTDbits.RD4
#define	GBIT							PORTCbits.RC7
#define CKBIT							PORTCbits.RC6
#define S1								PORTBbits.RB1
#define USBSENSE						PORTDbits.RD3
//
#define DEFAULT_CURRVAR					0
#define DEFAULT_TMR0CON					0x0083
#define DEFAULT_TMR0CONLOG				0x0082
//
#define ANCH0							0
#define ANCH1							1
#define ANCH2							2
#define ANCH3							3
#define ANCHLDR							4
#define ANCHBATT						5
//
#define DEFAULTBATTWAKEUPMODE           1
#define DEFAULT_INDEX					ANCH0
//
#define OUTPUT1							PORTEbits.RE1
#define OUTPUT2							PORTEbits.RE2
//
#define	DEFAULT_DECP					1
//
// EEPROM Settings
//
#define MAGIC_VALUE						0x76		// should not be 0xFF or 0x00 but any other value is ok!
#define MAGIC_VALUE_ADR					0			// offset to EEPROM memory
#define START_PERSISTENT_ADR			1
#define NUM_PERSISTENT_SETTINGS			25
//
#define MINBRIGHTNESS_ADR				1			// offset to EEPROM memory
#define MAXBRIGHTNESS_ADR				2
#define SCROLLSPEED_ADR					3
#define DISPLAYOBJECT_ADR				4
#define DISPLAYMODE_ADR					5
#define TMR0CON_ADR						6
#define TMR0CONLOG_ADR					7
#define TMR0HPERIOD_ADR					8
#define ROUNDINGMODE_ADR				9
#define SYSTEMDECP_ADR					10
#define BATTSCALINGL_ADR				11
#define BATTMIN_ADR						12
#define BATTMAX_ADR						13
#define SYSTEMNAMEL_ADR					14
#define SYSTEMNAMEH_ADR					15
#define ZEROACC_ADR						16
#define OUTPUT1_ADR						17
#define OUTPUT2_ADR						18
#define CHECKPERIOD_ADR					19
#define BEEPPERIOD_ADR					20
#define MINORDELAY_ADR					21
#define MAJORDELAY_ADR					22
#define INVERTMASK_ADR                  23
#define BATTSLEEPMODE_ADR               24
#define BATTWAKEUPMODE_ADR              25
#define LIMITPERIOD_ADR                 26
#define DISPLAY_OBJS_ADR				27
//
#define POLY_TABLE_ADR					39
#define POLY_MEMORY_ADR					(POLY_TABLE_ADR+MAX_POLY_INDEXES)
//
#define SIZE_OF_VARIABLE_TO_32_BYTE_BOUNDARY	(1+(int)(sizeof(VARIABLE)/32))
#define SIZE_OF_STRING_DATA_TO_32_BYTE_BOUNDARY ((int)(AVG_STRING_SIZE*NUM_STRINGS_PER_VAR/32))
#define SIZE_OF_STRINGS                         ((int)32*SIZE_OF_STRING_DATA_TO_32_BYTE_BOUNDARY*NUM_VARS)
/** V E C T O R  R E M A P P I N G *******************************************/
void myISR(void);
void myISRHigh(void);
void disAdec(int, int);
void disA(int, int);
void disWdec(int);
void updateANs(void);
double readAN(byte);
void setPWMDuty(int);
int WriteEEPROM(int, int);
int ReadEEPROM(int);

typedef struct
{
double value[NUM_VALUES];
double raw[NUM_RAW];
double scaling[NUM_SCALING];
double acc;
double max[NUM_VALUES];
double min[NUM_VALUES];
byte decp[NUM_RAW];
byte interpolation[NUM_RAW];
byte type;				// type, bits 1 and 0= ANALOG_VAR or FREQUENCY_VAR or DEPENDENT_VAR or SILENT_VAR
						// bits 5, 4 = value index for dependent variable (for its valueindex 0)
						// bits 7, 6 = value index for dependent variable (for its valueindex 1)
byte index;				// extra information for the variable
						// type: ANALOG_VAR type the lower 4 bits denote the channel number, for FREQ_VAR it is the channel number too etc.
						// bits 5,4 are the accumulator channel!
						// bit 6= 0 averaging on delta and delta dt values is disabled!
						// bit 6= 1 averaging on delta and delta dt values is enabled (as long as MODE_AVG is enabled for the variable)
						// bit 7= 0 indicates that delta & delta_dt indexes apply to value[0] of the variable
						// bit 7= 1 indicates that delta & delta_dt indexes apply to value[1] of the variable 
rom char *name[NUM_STRINGS_PER_VAR];
long updateTime;	
long updatePeriod;
byte updated;			// bit 0 = 1 when the values have been digitized and variable updated bit 1=1 when the polynomial has been computed for the points!
byte invert;
byte mode;				// bit 0= averaging enabled or disabled?
byte hysteresis;
byte extra, extra1;
} VARIABLE;				// variable should be aligned to a 32 byte boundary

typedef struct
{
double value[NUM_VALUES];
double raw[NUM_RAW];
double scaling[NUM_SCALING];
byte channel;
byte done;
} MAPPOINT;

/*
typedef struct
{
byte mode;			
} DISPLAYOBJECT;	// display object
*/

typedef byte DISPLAYOBJECT;
// displayObject= 
// bits 3-0 = physical channel 
// bits 5,4 = value index  
// bit 6    = display accumulator value instead!
// bit 7    = enable/disable display 

/*
typedef struct
{
byte mode;				// mode = bit 		7				6		5		4		3		2		1		0
						//					EN			MAX/~MIN	-		Value2	ch		ch		ch		ch (the channel)	
						//			if MAX/~MIN= 0 then the output goes 0 when value > max and 1 when < min if 1 then reversed
						//			EN=0  output disabled 1=enabled
						//			if Value2=0 then use value for the comparison otherwise use value2
} OUTPUT;
*/

typedef byte OUTPUT;

typedef union
{
	rom far char *pAdr;
    struct
    {
      byte low;                   //Little-endian order
      byte high;
      byte upper;
    };
} MEM_PTR;

#endif
